//+------------------------------------------------------------------+
//|                                        Custom Moving Average.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp.; Mod RonT"
#property link      "http://www.metaquotes.net/"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 White

//---- indicator parameters
extern int MA_Period=13;

//---- indicator buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];

//----
int ExtCountedBars=0;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   int    draw_begin;
   string short_name;

//---- drawing settings

   SetIndexStyle(0,DRAW_ARROW, 0, 1, Red);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexArrow(0,158);

   SetIndexStyle(1,DRAW_ARROW, 0, 1, White);
   SetIndexBuffer(1, ExtMapBuffer2);
   SetIndexArrow(1,159);

//   SetIndexShift(0,0);
//   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   
   if(MA_Period<2) MA_Period=13;
   draw_begin=MA_Period-1;

   short_name="SMA(";
   IndicatorShortName(short_name+MA_Period+")");
   SetIndexDrawBegin(0,draw_begin);

   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexBuffer(1, ExtMapBuffer2);

   SetIndexDrawBegin(0,10);
   SetIndexDrawBegin(1,10);

//---- initialization done
   return(0);
  }

//+------------------------------------------------------------------+
//| Main                                                             |
//+------------------------------------------------------------------+
int start()
  {
   if(Bars<=MA_Period) return(0);
   ExtCountedBars=IndicatorCounted();

//---- check for possible errors
   if (ExtCountedBars<0) return(-1);

//---- last counted bar will be recounted
   if (ExtCountedBars>0) ExtCountedBars--;

//----
   sma();

//---- done
   return(0);
  }

//+------------------------------------------------------------------+
//| Simple Moving Average                                            |
//+------------------------------------------------------------------+
void sma()
  {
   double sum=0;
   int    i,pos=Bars-ExtCountedBars-1;

//---- initial accumulation
   if(pos<MA_Period) pos=MA_Period;
   for(i=1;i<MA_Period;i++,pos--)
      sum+=Close[pos];

//---- main calculation loop
   while(pos>=0)
     {
      sum+=Close[pos];
      ExtMapBuffer1[pos]=sum/MA_Period;
      ExtMapBuffer2[pos]=(sum/MA_Period)+5;
	   sum-=Close[pos+MA_Period-1];
 	   pos--;
     }

//---- zero initial bars
   if(ExtCountedBars<1)
      for(i=1;i<MA_Period;i++) ExtMapBuffer1[Bars-i]=0;
      for(i=1;i<MA_Period;i++) ExtMapBuffer2[Bars-i]=0;
  }
//+------------------------------------------------------------------+

